rule Win32_Ransomware_Dualshot : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "DUALSHOT"
        description         = "Yara rule that detects Dualshot ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Dualshot"
        tc_detection_factor = 5

    strings:

        $internal_encrypt_file = {
            02 28 ?? ?? ?? ?? 0A 02 28 ?? ?? ?? ?? 0B 02 28 ?? ?? ?? ?? 0C 02 28 ?? ?? ?? ?? 03 28 
            ?? ?? ?? ?? 0D 02 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 25 09 16 09 8E 69 6F ?? 
            ?? ?? ?? 6F ?? ?? ?? ?? 02 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 06 28 ?? ?? ?? ?? 02 72 ?? ?? 
            ?? ?? 28 ?? ?? ?? ?? 07 28 ?? ?? ?? ?? 02 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 08 28 ?? ?? ?? 
            ?? 02 1B 19 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? DE ?? 26 DE ?? 00 02 28 ?? ?? ?? ?? DE ?? 26 
            DE ?? 2A 
        }

        $encrypt_files_p1 = {
            11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 32 ?? DE ?? 26 DE ?? 11 ?? 17 58 13 ?? 11 ?? 11 ?? 
            8E 69 32 ?? DE ?? 26 DE ?? 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 3F ?? ?? ?? ?? 11 ?? 13 
            ?? 16 13 ?? 2B ?? 11 ?? 11 ?? 9A 13 ?? 11 ?? 11 ?? 28 ?? ?? ?? ?? DE ?? 26 DE ?? 11 ?? 
            17 58 13 ?? 11 ?? 11 ?? 8E 69 32 ?? 72 ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 13 ?? 28 ?? ?? 
            ?? ?? 72 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? 
            ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 11 ?? 28 ?? ?? ?? ?? 25 28 ?? ?? ?? ?? 11 
            ?? 6F ?? ?? ?? ?? 16 28 ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 8E 69 6F ?? ?? ?? ?? 6F ?? ?? 
            ?? ?? 06 72 ?? ?? ?? ?? 12 ?? 6F ?? ?? ?? ?? 26 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 39 ?? 
            ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 08 1F ?? 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 12 
            ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 11 ?? 28 ?? ?? ?? ?? 11 ?? 72 ?? 
            ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 73 ?? ?? ?? ?? 25 17 6F ?? ?? ?? ?? 25 16 6F ?? 
            ?? ?? ?? 25 17 6F ?? ?? ?? ?? 25 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 72 ?? ?? ?? ?? 11 ?? 
            28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 DE ?? 
            26 DE ?? 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 
            13 ?? 12 ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 1B 8D ?? ?? ?? ?? 25 16 28 ?? ?? ?? ?? 6F ?? 
            ?? ?? ?? A2 25 17 72 ?? ?? ?? ?? A2 25 18 11 ?? A2 25 19 72 ?? ?? ?? ?? A2 25 1A 11 ?? 
            A2 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 09 2C ?? 73 ?? ?? ?? ?? 25 17 6F ?? ?? ?? ?? 25 16 6F 
            ?? ?? ?? ?? 25 17 6F ?? ?? ?? ?? 25 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 72 ?? ?? ?? ?? 6F 
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 2B ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 11 ?? 
            72 ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2A
        }

        $encrypt_files_p2 = {
            02 16 9A 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 39 ?? ?? ?? ?? 02 17 9A 28 ?? ?? ?? ?? 13 ?? 02 
            18 9A 28 ?? ?? ?? ?? 2C ?? 02 18 9A 28 ?? ?? ?? ?? 13 ?? 28 ?? ?? ?? ?? 11 ?? 28 ?? ?? 
            ?? ?? 6F ?? ?? ?? ?? 02 18 9A 1B 19 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? DE ?? 26 DE ?? 02 18 
            9A 28 ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 73 ?? ?? ?? ?? 28 
            ?? ?? ?? ?? 2A 1F ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 20 ?? ?? ?? ?? 6F 
            ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 28 ?? ?? ?? 
            ?? 6F ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 06 72 ?? ?? ?? ?? 12 ?? 6F ?? ?? ?? ?? 26 07 72 
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? 
            ?? ?? 6F ?? ?? ?? ?? DE ?? 26 DE ?? 11 ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 18 8D ?? ?? 
            ?? ?? 25 16 72 ?? ?? ?? ?? A2 25 17 72 ?? ?? ?? ?? A2 13 ?? 16 13 ?? 38 ?? ?? ?? ?? 00 
            1B 8D ?? ?? ?? ?? 25 16 28 ?? ?? ?? ?? A2 25 17 72 ?? ?? ?? ?? A2 25 18 08 20 ?? ?? ?? 
            ?? 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? A2 25 19 72 ?? ?? ?? ?? A2 
            25 1A 11 ?? 08 11 ?? 8E 69 6F ?? ?? ?? ?? 9A A2 28 ?? ?? ?? ?? 13 ?? 11 ?? 28 ?? ?? ?? 
            ?? 6F ?? ?? ?? ?? 73 ?? ?? ?? ?? 25 11 ?? 6F ?? ?? ?? ?? 25 17 6F ?? ?? ?? ?? 25 16 6F 
            ?? ?? ?? ?? 25 17 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 DE ?? 26 DE ?? 11 ?? 17 58 13 ?? 11 
            ?? 1F ?? 3F ?? ?? ?? ?? 73 ?? ?? ?? ?? 25 17 6F ?? ?? ?? ?? 25 16 6F ?? ?? ?? ?? 25 17 
            6F ?? ?? ?? ?? 25 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? 
            ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 28 ?? ?? ?? ?? 
            6F ?? ?? ?? ?? 2A 
        }

        $find_files_p1 = {
            73 ?? ?? ?? ?? 0A 06 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 06 72 ?? ?? ?? ?? 72 
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 2D ?? 72 ?? ?? ?? ?? 28 ?? ?? 
            ?? ?? 2C ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 73 ?? ?? ?? ?? 0C 28 ?? ?? ?? ?? 16 28 ?? ?? 
            ?? ?? 02 8E 39 ?? ?? ?? ?? 02 16 9A 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 39 ?? ?? ?? ?? 16 0D 
            28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ?? 17 0D 20 ?? ?? ?? ?? 
            28 ?? ?? ?? ?? 1F ?? 1B 28 ?? ?? ?? ?? 25 6F ?? ?? ?? ?? 13 ?? 6F ?? ?? ?? ?? 13 ?? 28 
            ?? ?? ?? ?? 72 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 12 ?? 
            28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 11 ?? 28 ?? ?? ?? ?? 25 11 ?? 16 11 
            ?? 8E 69 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 16 8D ?? ?? ?? ?? 13 ?? 1C 8D ?? ?? ?? ?? 25 16 
            72 ?? ?? ?? ?? A2 25 17 72 ?? ?? ?? ?? A2 25 18 72 ?? ?? ?? ?? A2 25 19 72 ?? ?? ?? ?? 
            A2 25 1A 72 ?? ?? ?? ?? A2 25 1B 72 ?? ?? ?? ?? A2 13 ?? 1F ?? 8D ?? ?? ?? ?? 25 16 72 
            ?? ?? ?? ?? A2 25 17 72 ?? ?? ?? ?? A2 25 18 72 ?? ?? ?? ?? A2 25 19 72 ?? ?? ?? ?? A2 
            25 1A 72 ?? ?? ?? ?? A2 25 1B 72 ?? ?? ?? ?? A2 25 1C 72 ?? ?? ?? ?? A2 25 1D 72 ?? ?? 
            ?? ?? A2 25 1E 72 ?? ?? ?? ?? A2 25 1F ?? 72 ?? ?? ?? ?? A2 25 1F ?? 72
        }

        $find_files_p2 = {
            A2 13 ?? 1F ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 28 ?? ?? ?? ?? 6F ?? 
            ?? ?? ?? 6F ?? ?? ?? ?? 1C 32 ?? 11 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 13 ?? 
            16 13 ?? 38 ?? ?? ?? ?? 11 ?? 11 ?? 9A 13 ?? 11 ?? 72 ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 
            72 ?? ?? ?? ?? 17 28 ?? ?? ?? ?? 13 ?? 16 13 ?? 2B ?? 11 ?? 11 ?? 9A 13 ?? 11 ?? 13 ?? 
            16 13 ?? 2B ?? 11 ?? 11 ?? 9A 13 ?? 11 ?? 72 ?? ?? ?? ?? 11 ?? 28 ?? ?? ?? ?? 6F ?? ?? 
            ?? ?? 2C ?? 12 ?? 11 ?? 8E 69 17 58 28 ?? ?? ?? ?? 11 ?? 11 ?? 16 6F ?? ?? ?? ?? 11 ?? 
            A2 2B
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $internal_encrypt_file
        )
}